/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.events;

import net.gigabit101.shrink.api.ShrinkAPI;
import net.gigabit101.shrink.cap.ShrinkImpl;
import net.gigabit101.shrink.config.ShrinkConfig;
import net.gigabit101.shrink.items.ItemModBottle;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="shrink")
public class PlayerEvents {
    @SubscribeEvent
    public static void cloneEvent(PlayerEvent.Clone evt) {
        evt.getOriginal().getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(old -> {
            CompoundTag compoundTag = (CompoundTag)old.serializeNBT();
            evt.getEntityLiving().getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(c -> c.deserializeNBT((Tag)compoundTag));
        });
    }

    @SubscribeEvent
    public static void respawnEvent(PlayerEvent.PlayerRespawnEvent evt) {
        evt.getPlayer().getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(c -> c.sync((LivingEntity)evt.getPlayer()));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        event.getPlayer().getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(c -> c.sync((LivingEntity)event.getPlayer()));
    }

    @SubscribeEvent
    public static void attachCaps(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof LivingEntity) {
            evt.addCapability(ShrinkImpl.Provider.NAME, (ICapabilityProvider)new ShrinkImpl.Provider((LivingEntity)evt.getObject()));
        }
    }

    @SubscribeEvent
    public static void playerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        player.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(c -> c.sync((LivingEntity)player));
    }

    @SubscribeEvent
    public static void playerStartTracking(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> iShrinkProvider.sync(livingEntity));
        }
    }

    @SubscribeEvent
    public static void joinWorldEvent(EntityJoinWorldEvent event) {
        if (!event.getWorld().m_5776_() && event.getEntity() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)event.getEntity();
            livingEntity.m_6210_();
            livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> iShrinkProvider.sync(livingEntity));
        }
    }

    @SubscribeEvent
    public static void itemInteractionForEntity(PlayerInteractEvent.EntityInteract event) {
        if (!((Boolean)ShrinkConfig.ENABLE_MOB_BOTTLES.get()).booleanValue()) {
            return;
        }
        if (!event.getWorld().m_5776_() && event.getTarget() instanceof LivingEntity && !(event.getTarget() instanceof Player)) {
            Player playerEntity = event.getPlayer();
            if (event.getTarget() instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)event.getTarget();
                if (playerEntity.m_21120_(event.getHand()).m_41720_() == Items.f_42590_) {
                    livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                        if (iShrinkProvider.isShrunk()) {
                            playerEntity.m_21120_(event.getHand()).m_41774_(1);
                            ItemStack output = ItemModBottle.setContainedEntity(event.getItemStack(), livingEntity);
                            playerEntity.m_150109_().m_36054_(output);
                        }
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public static void changeSize(EntityEvent.Size event) {
        if (event.getEntity() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)event.getEntity();
            livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                double x = event.getEntity().m_20185_();
                double y = event.getEntity().m_20186_();
                double z = event.getEntity().m_20189_();
                if (iShrinkProvider.isShrunk()) {
                    event.setNewSize(event.getNewSize().m_20388_(iShrinkProvider.scale()));
                    event.setNewEyeHeight(event.getNewEyeHeight() * iShrinkProvider.scale());
                }
            });
        }
    }
}

